import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viserpay_agent/core/utils/dimensions.dart';
import 'package:viserpay_agent/core/utils/style.dart';
import 'package:viserpay_agent/data/controller/add_money/add_money_method_controller.dart';
import 'package:viserpay_agent/data/model/add_money/add_money_method_response_model.dart';
import 'package:viserpay_agent/view/components/bottom-sheet/bottom_sheet_header_row.dart';
import 'package:viserpay_agent/view/components/card/bottom_sheet_card.dart';

class AddMoneyGatewayBottomSheet extends StatelessWidget {
  const AddMoneyGatewayBottomSheet({super.key});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<AddMoneyMethodController>(
      builder: (controller) => Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          const BottomSheetHeaderRow(header: ''),
          const SizedBox(height: Dimensions.space15),
          ListView.builder(
              itemCount: controller.gatewayList.length,
              shrinkWrap: true,
              physics: const BouncingScrollPhysics(),
              itemBuilder: (context, index) {
                return Material(
                  color: Colors.transparent,
                  child: InkWell(
                    onTap: () {
                      Gateways selectedValue = controller.gatewayList[index];
                      controller.setGatewayMethod(selectedValue);
                      Navigator.pop(context);

                      FocusScopeNode currentFocus = FocusScope.of(context);
                      if (!currentFocus.hasPrimaryFocus) {
                        currentFocus.unfocus();
                      }
                    },
                    child: BottomSheetCard(
                      child: Text(
                        controller.gatewayList[index].name.toString() ?? "",
                        style: regularDefault,
                      ),
                    ),
                  ),
                );
              })
        ],
      ),
    );
  }
}
